{pkgs}: {
  channel = "stable-24.05";
  packages = [
    pkgs.nodejs_22
    pkgs.volta
  ];

  services = {
    postgres = {
      enable = true;
      package = pkgs.postgresql;
    };
  };

  idx.extensions = [
    "esbenp.prettier-vscode"
    "dbaeumer.vscode-eslint"
    "bradlc.vscode-tailwindcss"
    "dsznajder.es7-react-js-snippets"
    "DavidAnson.vscode-markdownlint"
    "EditorConfig.EditorConfig"
    "mikestead.dotenv"
    "streetsidesoftware.code-spell-checker"
    "usernamehw.errorlens"
  ];
  workspace = {
      # Runs when a workspace is first created with this `dev.nix` file
      onCreate = {
        npm-install = "npm ci --no-audit --prefer-offline --no-progress --timing";
        # Open editors for the following files by default, if they exist:
        # default.openFiles = [ "src/App.tsx" "src/App.ts" "src/App.jsx" "src/App.js" ];

        # if db not created use this command
        #   initdb -D local
        setup-postgres = ''
          psql --dbname=postgres -c "ALTER USER \"user\" PASSWORD 'mypassword';"
          psql --dbname=postgres -c "CREATE DATABASE youtube;"
          psql --dbname=youtube -f create.sql
          psql --dbname=youtube -f example.sql
        '';
      };
      # To run something each time the workspace is (re)started, use the `onStart` hook
   };
  idx.previews = {
    previews = {
      web = {
        command = [
          "pnpm"
          "dev"
          "--"
          "--port"
          "$PORT"
          "--hostname"
          "0.0.0.0"
        ];
        manager = "web";
      };
    };
  };
}