// Mendapatkan semua elemen dengan class "question-list"
let questionList = document.querySelectorAll(
  '[class*="not-filled-in question-"]'
);

// Melakukan perulangan untuk setiap pertanyaan
questionList.forEach((radioGroup, i) => {
  // Mendapatkan semua input radio dalam satu grup
  const radioOptions = radioGroup.querySelectorAll(".option-jawaban");

  // Menghitung nilai acak antara 1 dan 100
  const randomValue = Math.floor(Math.random() * 100) + 1;

  // Menentukan nilai input radio berdasarkan skenario yang diberikan
  radioOptions.forEach((radio) => {
    const options = radio.querySelectorAll('.opsi-radio input[type="radio"]');

    try {
      if (randomValue <= 70) {
        options[3].checked = true; // Sangat Setuju
      } else if (randomValue <= 90) {
        options[2].checked = true; // Setuju
      } else {
        options[1].checked = true; // Tidak Setuju
      }

      console.log(`Berhasil menjawab pertanyaan ke-${i + 1}`);
    } catch (err) {
      console.error(`Gagal menjawab pertanyaan ke-${i + 1}` + err.message);
    }
  });
});
