#include <WiFi.h>
#include <Firebase_ESP_Client.h>
#include <DHT.h>
#include "addons/TokenHelper.h"
#include "addons/RTDBHelper.h"

// ====== KONFIGURASI WIFI ======
#define WIFI_SSID "sandata"
#define WIFI_PASSWORD "gnulibre567"

// ====== KONFIGURASI FIREBASE ======
#define API_KEY "AIzaSyAO4ja4G-y20Qv20pe_kU7-vItW908nec4"
#define DATABASE_URL "https://penyiramanotomatis-3f962-default-rtdb.asia-southeast1.firebasedatabase.app/"

// ====== PIN SENSOR DAN RELAY ======
#define DHTPIN 4
#define DHTTYPE DHT11
#define SOIL_PIN 36
#define RELAY_PIN 5

DHT dht(DHTPIN, DHTTYPE);

FirebaseData fbdo;
FirebaseAuth auth;
FirebaseConfig config;

unsigned long sendDataPrevMillis = 0;
bool signupOK = false;
bool modeOtomatis = true; 

int moistureThreshold = 30; // default kalau Firebase gagal
unsigned long lastFetchThreshold = 0;

void fetchThresholdFromFirebase() {
  if (Firebase.RTDB.getInt(&fbdo, "controls/pump/moisture_threshold")) {
    moistureThreshold = fbdo.intData();
    Serial.println("Threshold diperbarui: " + String(moistureThreshold) + "%");
  } else {
    Serial.println("Gagal ambil threshold: " + fbdo.errorReason());
  }
}

void setup() {
  Serial.begin(115200);
  dht.begin();
  pinMode(SOIL_PIN, INPUT);
  pinMode(RELAY_PIN, OUTPUT);
  digitalWrite(RELAY_PIN, LOW);

  // ====== KONEKSI WIFI ======
  WiFi.begin(WIFI_SSID, WIFI_PASSWORD);
  Serial.print("Menghubungkan WiFi");
  while (WiFi.status() != WL_CONNECTED) {
    Serial.print(".");
    delay(300);
  }
  Serial.println("\nTerhubung ke WiFi!");

  // ====== KONFIGURASI FIREBASE ======
  config.api_key = API_KEY;
  config.database_url = DATABASE_URL;

  if (Firebase.signUp(&config, &auth, "", "")) {
    Serial.println("Firebase SignUp OK");
    signupOK = true;
  } else {
    Serial.printf("SignUp Error: %s\n", config.signer.signupError.message.c_str());
  }

  Firebase.begin(&config, &auth);
  Firebase.reconnectWiFi(true);
}

void loop() {
  if (!Firebase.ready() || !signupOK) return;

  // === BACA SENSOR ===
  float suhu = dht.readTemperature();
  float kelembapanUdara = dht.readHumidity();
  int soilValue = analogRead(SOIL_PIN);
  float kelembapanTanah = map(soilValue, 4095, 0, 0, 100);

  Serial.println("===========================");
  Serial.println("Suhu: " + String(suhu) + "°C");
  Serial.println("Kelembapan Udara: " + String(kelembapanUdara) + "%");
  Serial.println("Kelembapan Tanah: " + String(kelembapanTanah) + "%");

  // === BACA MODE DARI FIREBASE ===
  if (Firebase.RTDB.getString(&fbdo, "controls/pump/mode")) {
    String mode = fbdo.stringData();
    modeOtomatis = (mode == "otomatis");
  }

  fetchThresholdFromFirebase();

  // === KONTROL POMPA ===
  if (modeOtomatis) {
    if (kelembapanTanah < moistureThreshold) {
      digitalWrite(RELAY_PIN, LOW); // pompa menyala
      Firebase.RTDB.setStringAsync(&fbdo, "status/pompa", "ON");
      Serial.println("Pompa ON (otomatis - tanah kering)");
    } else {
      digitalWrite(RELAY_PIN, HIGH); // pompa mati
      Firebase.RTDB.setStringAsync(&fbdo, "status/pompa", "OFF");
      Serial.println("Pompa OFF (otomatis - tanah lembap)");
    }
  } else {
    // === MODE MANUAL ===
    if (Firebase.RTDB.getString(&fbdo, "status/pompa")) {
      String control = fbdo.stringData();
      if (control == "ON") {
        digitalWrite(RELAY_PIN, HIGH);
        Serial.println("Pompa ON (manual)");
      } else {
        digitalWrite(RELAY_PIN, LOW);
        Serial.println("Pompa OFF (manual)");
      }
    }
  }

  // === KIRIM DATA SENSOR SETIAP 3 DETIK ===
  if (millis() - sendDataPrevMillis > 3000) {
    sendDataPrevMillis = millis();
    Firebase.RTDB.setFloat(&fbdo, "sensor/suhu", suhu);
    Firebase.RTDB.setFloat(&fbdo, "sensor/kelembapan_udara", kelembapanUdara);
    Firebase.RTDB.setFloat(&fbdo, "sensor/kelembapan_tanah", kelembapanTanah);
    Serial.println("Data sensor dikirim ke Firebase!");
  }

  delay(3000);
}